/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.remotesupport.service;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.remotesupport.service.RsfServiceSettingsConstants;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.rcs.conndata.CecInfo;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsfServiceSettingsBean
extends PanelBean
implements RsfServiceSettingsConstants {
    private static final String TRACE_MASKT = "JRSFSSBT";
    private static final String TRACE_MASKF = "JRSFSSBF";
    private static final String TRACE_MASKD = "JRSFSSBD";
    private static final ClassLogInfo classLogInfo = new ClassLogInfo(-88, -123, "RSF-SrvSBean");
    private CecInfo consoleInfo;
    private List managedSystems;
    private Map enablement;
    private LocalizableText enabledText = new LocalizableText("com.ibm.hsc.common.bundles.RemoteSupportBundle", "STATUS_ENABLED");
    private LocalizableText disabledText = new LocalizableText("com.ibm.hsc.common.bundles.RemoteSupportBundle", "STATUS_DISABLED");
    private transient ItemDescriptor[][] m_idManagedSystemsTable;
    private transient ColumnDescriptor[] m_cdManagedSystemsTableStructure;
    private transient int[] m_iManagedSystemsTableSelection;

    public RsfServiceSettingsBean() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> RsfServiceSettingsBean()");
    }

    public void setManagedSystemsTableSelection(int[] nArray) throws IllegalUserDataException {
        if (nArray != null && nArray.length > 0) {
            Trace.trace((String)TRACE_MASKF, (Object)("-> setManagedSystemsTableSelection(" + nArray.length + ")"));
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"-> setManagedSystemsTableSelection(none)");
        }
        this.m_iManagedSystemsTableSelection = nArray;
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKF, (Object)"<- setManagedSystemsTableSelection()");
    }

    public int[] getManagedSystemsTableSelection() {
        return this.m_iManagedSystemsTableSelection;
    }

    public void setManagedSystemsTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idManagedSystemsTable[n] = itemDescriptorArray;
    }

    public ItemDescriptor[] getManagedSystemsTableRowAt(int n) {
        return this.m_idManagedSystemsTable[n];
    }

    public int getManagedSystemsTableRowCount() {
        return this.m_idManagedSystemsTable.length;
    }

    public int getManagedSystemsTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getManagedSystemsTableRowStructure() {
        return this.m_cdManagedSystemsTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> verifyChanges()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- verifyChanges()");
    }

    public void load() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> load()");
        this.m_idManagedSystemsTable = new ItemDescriptor[0][0];
        this.m_cdManagedSystemsTableStructure = new ColumnDescriptor[0];
        this.m_iManagedSystemsTableSelection = new int[0];
        Trace.trace((String)TRACE_MASKT, (Object)"<- load()");
    }

    public void save() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> save()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- save()");
    }

    public void setConsoleInfo(CecInfo cecInfo) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setConsoleInfo(" + cecInfo + ")"));
        this.consoleInfo = cecInfo;
    }

    public void setManagedSystems(List list) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setManagedSystems(" + list.size() + ")"));
        this.managedSystems = list;
    }

    public void setEnablement(Map map) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setEnablement(" + map.size() + ")"));
        this.enablement = map;
    }

    public Map getEnablement() {
        Trace.trace((String)TRACE_MASKT, (Object)("<> getEnablement() " + this.enablement.size()));
        return this.enablement;
    }

    public void prepare() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> prepare()");
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKT, (Object)"<- prepare()");
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> panelAction(" + taskActionEvent + ")"));
        try {
            String string = taskActionEvent.getElementName();
            if (string.endsWith("OkButton")) {
                try {
                    this.userTaskManager.storeAllElements();
                    PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                    panelTaskletRequest.setSource((Object)"RsfServiceSettingsBean");
                    panelTaskletRequest.setData("Source", (Object)"ServiceSettingsPanel");
                    panelTaskletRequest.setData("Command", (Object)"Commit");
                    panelTaskletRequest.setData("Bean", (Object)this);
                    this.postTaskletRequest(panelTaskletRequest);
                }
                catch (IllegalUserDataException illegalUserDataException) {}
            } else if (string.endsWith("EnableButton")) {
                String string2 = this.enabledText.toString();
                int[] nArray = this.getManagedSystemsTableSelection();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    ItemDescriptor itemDescriptor = this.m_idManagedSystemsTable[n][1];
                    String string3 = itemDescriptor.getTitle();
                    this.enablement.remove(string3);
                    this.m_idManagedSystemsTable[n][2] = new ItemDescriptor(null, string2);
                    Trace.trace((String)TRACE_MASKF, (Object)("Enabled remote service for " + string3));
                }
                this.updateUTMElements();
            } else if (string.endsWith("DisableButton")) {
                String string4 = this.disabledText.toString();
                int[] nArray = this.getManagedSystemsTableSelection();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    ItemDescriptor itemDescriptor = this.m_idManagedSystemsTable[n][1];
                    String string5 = itemDescriptor.getTitle();
                    this.enablement.put(string5, new Boolean(false));
                    this.m_idManagedSystemsTable[n][2] = new ItemDescriptor(null, string4);
                    Trace.trace((String)TRACE_MASKF, (Object)("Disabled remote service for " + string5));
                }
                this.updateUTMElements();
            } else if (string.endsWith("CancelButton")) {
                this.dispose();
            }
        }
        catch (RuntimeException runtimeException) {
            new AusMicrocodeLog(classLogInfo, 5, runtimeException).writeEntryFromTaskletClient();
            this.dispose();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- panelAction()");
    }

    public void update(Object object) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> update()");
        try {
            HashMap hashMap = (HashMap)object;
            String string = (String)hashMap.get("Command");
            if (string == null) {
                string = "";
            }
            Trace.trace((String)TRACE_MASKF, (Object)("command=" + string));
            if (string.equals("")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
            }
        }
        catch (RuntimeException runtimeException) {
            new AusMicrocodeLog(classLogInfo, 5, runtimeException).writeEntryFromTaskletClient();
            this.dispose();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- update()");
    }

    private void updateDataBeanInfo(boolean bl) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> updateDataBeanInfo(" + bl + ")"));
        int n = this.managedSystems.size();
        Trace.trace((String)TRACE_MASKF, (Object)("managedSystems=" + n));
        if (bl) {
            String string = this.enabledText.toString();
            String string2 = this.disabledText.toString();
            this.m_idManagedSystemsTable = new ItemDescriptor[n + 1][3];
            String string3 = this.consoleInfo.getUserName();
            this.m_idManagedSystemsTable[0][0] = new ItemDescriptor(null, string3);
            String string4 = this.consoleInfo.getType() + "-" + this.consoleInfo.getModel() + "/" + this.consoleInfo.getSerial();
            this.m_idManagedSystemsTable[0][1] = new ItemDescriptor(null, string4);
            String string5 = string;
            if (this.enablement.containsKey(string4) && !((Boolean)this.enablement.get(string4)).booleanValue()) {
                string5 = string2;
            }
            this.m_idManagedSystemsTable[0][2] = new ItemDescriptor(null, string5);
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    CecInfo cecInfo = (CecInfo)this.managedSystems.get(i);
                    string3 = cecInfo.getUserName();
                    this.m_idManagedSystemsTable[i + 1][0] = new ItemDescriptor(null, string3);
                    string4 = cecInfo.getType() + "-" + cecInfo.getModel() + "/" + cecInfo.getSerial();
                    this.m_idManagedSystemsTable[i + 1][1] = new ItemDescriptor(null, string4);
                    string5 = string;
                    if (this.enablement.containsKey(string4) && !((Boolean)this.enablement.get(string4)).booleanValue()) {
                        string5 = string2;
                    }
                    this.m_idManagedSystemsTable[i + 1][2] = new ItemDescriptor(null, string5);
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String string = this.getMountPrefix();
            if (this.m_iManagedSystemsTableSelection.length >= 1) {
                this.userTaskManager.setEnabled(string + "EnableButton", true);
                this.userTaskManager.setEnabled(string + "DisableButton", true);
            } else {
                this.userTaskManager.setEnabled(string + "EnableButton", false);
                this.userTaskManager.setEnabled(string + "DisableButton", false);
            }
            this.userTaskManager.refreshAllElements();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- updateUTMElements()");
    }
}

